<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Request\Request;

global $ulz_explore, $ulz_search_form_id, $ulz_search_form_id_more;

if( ! $ulz_search_form_id ) {
    return;
}

$request = Request::instance();

?>

<div class="ulz-modal ulz-modal-filters" data-id="filters">
    <?php Ucore()->the_template('modals/close'); ?>
    <div class="ulz-modal-heading ulz--border">
        <h4 class="ulz--title"><?php esc_html_e( 'More filters', 'utillz-core' ); ?></h4>
    </div>
    <div class="ulz-modal-content">
        <div class="ulz-modal-append">
            <div class="ulz-modal-container ulz-scrollbar">

                <?php if( current_user_can('manage_options') && ! get_option('ulz_hide_edit_search_form') ): ?>
                    <div class="ulz-mb-2">
                        <a href="<?php echo esc_url( get_edit_post_link( $ulz_search_form_id_more ) ); ?>" class="ulz-no-decoration ulz-text-right" target="_blank">
                            <?php esc_html_e( 'Edit search form', 'utillz-core' ); ?>
                            <i class="fas fa-external-link-alt ulz-ml-1"></i>
                        </a>
                    </div>
                <?php endif; ?>

                <div class="ulz-search-filter" data-form-id="<?php echo (int) $ulz_search_form_id_more; ?>">
                    <div class="ulz-grid">

                        <?php

                            $filters = Ucore()->json_decode( Ucore()->get( 'ulz_search_fields', $ulz_search_form_id_more ) );
                            if( ! empty( $filters ) ) {
                                $ulz_explore->component->tabs( $filters );
                            }

                        ?>

                    </div>
                </div>

            </div>

            <div class="ulz-modal-footer ulz--top-border ulz-text-center">
                <a href="#" class="ulz-button ulz-button-accent ulz-modal-button ulz-action-filter">
                    <span><?php esc_html_e( 'Search', 'utillz-core' ); ?></span>
                    <?php Ucore()->preloader(); ?>
                </a>
            </div>

        </div>
        <?php Ucore()->preloader(); ?>
    </div>
</div>
